#version 330
#extension GL_EXT_gpu_shader4 : enable
// Sweet roadMod01.fsh  by  gaz

//https://www.shadertoy.com/view/WllfzS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float Scale;
float map(vec3 p)
{
   float s=2.;
    for(int i = 0; i < 4; i++) {
        p=mod(p-1.,2.)-1.;
		float r2=1.2/dot(p,p);
    	p*=r2;
    	s*=r2;
    }
    Scale=log2(s);
    p = abs(p)-0.8;
    if (p.x < p.z) p.xz = p.zx;
    if (p.y < p.z) p.yz = p.zy;
    if (p.x < p.y) p.xy = p.yx;
    return length(cross(p,normalize(vec3(0,.5,1))))/s-Scale*.0015;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv=(2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
	vec3 p,
  		ro=vec3(1.,1.,iTime),
  		w=normalize(vec3(.1*sin(iTime*.5),.3,1)),
  		u=normalize(cross(w,vec3(cos(-iTime*.16),sin(-iTime*.16),0))),
  		rd=mat3(u,cross(u,w),w)*normalize(vec3(uv,2));
	float h=0.,d,i;
	for(i=1.;i<100.;i++)
    {
    	p=ro+rd*h;
		d=map(p);
    	if(d<.0001)break;
    	h+=d;
	}
    gl_FragColor.xyz=35.*vec3(vec3(.7,.9,.7)*cos(Scale*.3)+(cos(p.xyy)*.5+.5))/i;
    gl_FragColor.a = 1.0;

}
